/*
 * Decompiled with CFR 0.152.
 */
package com.midronome.midrosyncfilegenerator;

import com.midronome.midrosyncfilegenerator.BpmRow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class WavFileGenerator
extends Task<Void> {
    private static final double TICK_HEIGHT = 0.35;
    private static final double BAR_TICK_HEIGHT = 0.95;
    private final int bitRate;
    private long totalOfSamples;
    private final List<BpmRow> bpmRows;
    private final int sampleRate;
    private final double negDelayInMs;
    private OutputStream fileStream;
    private long currentSample;
    private double startOfNextBpmRow;
    private final File file;
    private final String fileName;
    private final Label errorLabel;
    private final Button genButton;
    private final Button cancelButton;

    public WavFileGenerator(List<BpmRow> bpmRows, int sampleRate, int bitRate, double negDelayInMs, File file, Label errorLabel, Button genButton, Button cancelButton) {
        this.bpmRows = bpmRows;
        this.sampleRate = sampleRate;
        this.bitRate = bitRate;
        this.negDelayInMs = negDelayInMs;
        this.file = file;
        this.errorLabel = errorLabel;
        this.genButton = genButton;
        this.cancelButton = cancelButton;
        String fn = file.getName();
        this.fileName = fn.length() <= 30 ? fn : fn.substring(0, 13) + "..." + fn.substring(fn.length() - 13);
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void updateProgress() {
        super.updateProgress(this.currentSample, this.totalOfSamples);
        int percent = (int)Math.round(100.0 * (double)this.currentSample / (double)this.totalOfSamples);
        String msg = "Generating " + this.fileName + "... " + percent + "%";
        Platform.runLater(() -> this.errorLabel.setText(msg));
    }

    private void writeTicks(int rowNum) throws IOException, InterruptedException {
        int i;
        BpmRow row = this.bpmRows.get(rowNum);
        int ticksPerBar = 24 * row.getBeatsPerBar();
        double tickLengthInSamples = (double)this.sampleRate * 60.0 / ((double)row.getBpm() * 24.0);
        double samplesPerBar = tickLengthInSamples * (double)ticksPerBar;
        double startOfNextTick = this.startOfNextBpmRow;
        if (rowNum == 0) {
            long delayShift = 0L;
            if (startOfNextTick < 0.0) {
                while (startOfNextTick < 0.0) {
                    if (startOfNextTick + 13.0 > 0.0) {
                        delayShift = (long)Math.ceil(-startOfNextTick);
                        if (startOfNextTick < -7.0) {
                            delayShift -= 14L;
                        }
                        startOfNextTick += (double)delayShift;
                    }
                    if (!(startOfNextTick < 0.0)) continue;
                    startOfNextTick += tickLengthInSamples;
                }
                while (this.currentSample < Math.round(startOfNextTick)) {
                    this.writeSample(0.0);
                }
            }
            this.startOfNextBpmRow += (double)delayShift;
        }
        double startOfNextBar = this.startOfNextBpmRow + samplesPerBar;
        this.startOfNextBpmRow += samplesPerBar * (double)row.getBars();
        while (this.currentSample < Math.round(this.startOfNextBpmRow)) {
            while (this.currentSample < Math.round(startOfNextBar)) {
                if (this.isCancelled()) {
                    throw new InterruptedException();
                }
                startOfNextTick += tickLengthInSamples;
                for (i = 0; i < 10; ++i) {
                    this.writeSample(0.35);
                }
                if (startOfNextTick + 1.0 > startOfNextBar) {
                    this.writeSampleSlope(0.35, 0.95, 5);
                    this.writeSample(0.95);
                    this.writeSample(0.95);
                    this.writeSampleSlope(0.95, 0.0, 9);
                } else {
                    this.writeSampleSlope(0.35, 0.0, 3);
                }
                while (this.currentSample < Math.round(startOfNextTick)) {
                    this.writeSample(0.0);
                }
                this.updateProgress();
            }
            startOfNextBar += samplesPerBar;
        }
        if (rowNum == this.bpmRows.size() - 1 && this.currentSample < this.totalOfSamples) {
            tickLengthInSamples = (double)this.sampleRate * 60.0 / ((double)this.bpmRows.get(0).getBpm() * 24.0);
            startOfNextTick = this.startOfNextBpmRow;
            while (this.currentSample < this.totalOfSamples) {
                if (this.isCancelled()) {
                    throw new InterruptedException();
                }
                startOfNextTick += tickLengthInSamples;
                if (this.currentSample + 13L > this.totalOfSamples) {
                    while (this.currentSample < this.totalOfSamples) {
                        this.writeSample(0.0);
                    }
                } else {
                    for (i = 0; i < 10; ++i) {
                        this.writeSample(0.35);
                    }
                    this.writeSampleSlope(0.35, 0.0, 3);
                    while (this.currentSample < Math.round(startOfNextTick) && this.currentSample < this.totalOfSamples) {
                        this.writeSample(0.0);
                    }
                }
                this.updateProgress();
            }
        }
    }

    @Override
    protected Void call() {
        Object msg;
        int byteRate = this.sampleRate * this.bitRate / 8;
        int blockAlign = this.bitRate / 8;
        double totalOfSamplesFloat = 0.0;
        for (BpmRow row : this.bpmRows) {
            totalOfSamplesFloat += row.getRowLengthInSeconds() * (double)this.sampleRate;
        }
        this.totalOfSamples = Math.round(totalOfSamplesFloat);
        Object infoMsg = "";
        try {
            this.fileStream = new FileOutputStream(this.file);
            this.fileStream.write("RIFF".getBytes());
            this.write32bInt((int)this.totalOfSamples * blockAlign + 36);
            this.fileStream.write("WAVE".getBytes());
            this.fileStream.write("fmt ".getBytes());
            this.write32bInt(16);
            this.write16bInt((short)1);
            this.write16bInt((short)1);
            this.write32bInt(this.sampleRate);
            this.write32bInt(byteRate);
            this.write16bInt((short)blockAlign);
            this.write16bInt((short)this.bitRate);
            this.fileStream.write("data".getBytes());
            this.write32bInt((int)this.totalOfSamples * blockAlign);
            this.currentSample = 0L;
            this.startOfNextBpmRow = this.negDelayInMs > 0.0 ? (double)Math.round(-this.negDelayInMs * (double)this.sampleRate / 1000.0) : (double)Math.round(this.negDelayInMs * (double)this.sampleRate / 1000.0);
            msg = "Generating " + this.fileName + "... 0%";
            Platform.runLater(() -> this.lambda$call$1((String)msg));
            for (int i = 0; i < this.bpmRows.size(); ++i) {
                this.writeTicks(i);
            }
            this.fileStream.close();
        }
        catch (InterruptedException e) {
            infoMsg = "Wave File Generation cancelled.";
            System.out.println((String)infoMsg);
            try {
                this.fileStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                infoMsg = "Error: " + ex.getMessage();
            }
            if (this.file.delete()) {
                System.out.println("Deleted " + this.file.getName() + " file");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            infoMsg = "Error: " + e.getMessage();
        }
        msg = infoMsg;
        Platform.runLater(() -> this.lambda$call$2((String)msg));
        return null;
    }

    private void write32bInt(int value) throws IOException {
        byte[] buffer = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.fileStream.write(buffer);
    }

    private void write24bInt(int value) throws IOException {
        byte[] buffer = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF)};
        this.fileStream.write(buffer);
    }

    private void write16bInt(short value) throws IOException {
        byte[] buffer = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        this.fileStream.write(buffer);
    }

    private void writeSample(double value) throws IOException {
        double maxAmplitude = (1 << this.bitRate - 1) - 1;
        int val = (int)Math.round(value * maxAmplitude);
        if (this.bitRate == 24) {
            this.write24bInt(val);
        } else {
            this.write16bInt((short)val);
        }
        ++this.currentSample;
    }

    private void writeSampleSlope(double from, double to, int samples) throws IOException {
        for (int i = 0; i < samples; ++i) {
            this.writeSample(from + (to - from) * (double)i / (double)samples);
        }
    }

    private /* synthetic */ void lambda$call$2(String msg) {
        this.genButton.setDisable(false);
        this.cancelButton.setVisible(false);
        this.errorLabel.setPrefWidth(-1.0);
        this.errorLabel.setText(msg);
    }

    private /* synthetic */ void lambda$call$1(String msg) {
        this.errorLabel.setText(msg);
        this.errorLabel.setPrefWidth((int)Math.ceil(this.errorLabel.prefWidth(-1.0)) + 8);
    }
}

