/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiSource;
import uk.co.xfactorylibrarians.coremidi4j.Loader;

public class CoreMidiInputPort {
    private final int midiPortReference;
    private long memoryHandle;

    public CoreMidiInputPort(int clientReference, String portName) throws CoreMidiException {
        this.midiPortReference = this.createInputPort(clientReference, portName);
    }

    public void connectSource(CoreMidiSource sourceDevice) throws CoreMidiException {
        this.memoryHandle = this.midiPortConnectSource(this.midiPortReference, sourceDevice);
    }

    public void disconnectSource(CoreMidiSource sourceDevice) throws CoreMidiException {
        this.midiPortDisconnectSource(this.midiPortReference, this.memoryHandle, sourceDevice);
    }

    private native int createInputPort(int var1, String var2) throws CoreMidiException;

    private native long midiPortConnectSource(int var1, CoreMidiSource var2) throws CoreMidiException;

    private native void midiPortDisconnectSource(int var1, long var2, CoreMidiSource var4) throws CoreMidiException;

    static {
        try {
            Loader.load();
        }
        catch (Throwable t) {
            System.err.println("Unable to load native library, CoreMIDI4J will stay inactive: " + t);
        }
    }
}

