/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;

public class Loader {
    private static final int BUFFER_SIZE = 8192;
    public static final String NATIVE_LIBRARY_NAME = "libCoreMidi4J.dylib";
    private static File tempDir;
    private static boolean loaded;
    private static boolean available;

    private Loader() {
    }

    private static boolean isMacOSX() {
        String os = System.getProperty("os.name").toLowerCase().replace(" ", "");
        return os.equals("osx") || os.equals("macosx");
    }

    private static File createTempDirectory() throws CoreMidiException {
        if (tempDir != null) {
            return tempDir;
        }
        try {
            tempDir = File.createTempFile("coreMidi4J", null);
            if (!tempDir.delete()) {
                throw new IOException("Unable to delete temporary file " + tempDir);
            }
            if (!tempDir.mkdirs()) {
                throw new IOException("Unable to create temporary directory " + tempDir);
            }
            tempDir.deleteOnExit();
            return tempDir;
        }
        catch (IOException e) {
            throw new CoreMidiException("Unable to create temporary directory for CoreMidi4J library: " + e, e);
        }
    }

    private static void copy(InputStream input, File output) throws IOException {
        byte[] buffer = new byte[8192];
        try (FileOutputStream stream = new FileOutputStream(output);){
            int read;
            while ((read = input.read(buffer)) != -1) {
                stream.write(buffer, 0, read);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String locateLibrary() throws CoreMidiException {
        String source = "/uk/co/xfactorylibrarians/coremidi4j/libCoreMidi4J.dylib";
        URL url = Loader.class.getResource("/uk/co/xfactorylibrarians/coremidi4j/libCoreMidi4J.dylib");
        if (url == null) {
            throw new CoreMidiException("Native library /uk/co/xfactorylibrarians/coremidi4j/libCoreMidi4J.dylib not found in classpath.");
        }
        if ("file".equals(url.getProtocol())) {
            try {
                return new File(url.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                System.err.println("Problem trying to obtain File from dynamic library: " + e);
            }
        }
        File dest = new File(Loader.createTempDirectory(), NATIVE_LIBRARY_NAME);
        try {
            InputStream stream = Loader.class.getResourceAsStream("/uk/co/xfactorylibrarians/coremidi4j/libCoreMidi4J.dylib");
            if (stream == null) {
                throw new CoreMidiException("Unable to find /uk/co/xfactorylibrarians/coremidi4j/libCoreMidi4J.dylib in the classpath");
            }
            try {
                Loader.copy(stream, dest);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new CoreMidiException("Unable to extract native library /uk/co/xfactorylibrarians/coremidi4j/libCoreMidi4J.dylib to " + dest + ": " + e, e);
        }
        dest.deleteOnExit();
        return dest.getAbsolutePath();
    }

    public static synchronized void load() throws CoreMidiException {
        if (loaded) {
            return;
        }
        loaded = true;
        if (Loader.isMacOSX()) {
            System.load(Loader.locateLibrary());
            available = true;
        }
    }

    public static synchronized boolean isAvailable() throws CoreMidiException {
        Loader.load();
        return available;
    }

    static {
        loaded = false;
        available = false;
    }
}

